#include "InstantMessageMgr.h"
#include "MeetingSDKWrap.h"
#include "csf/RWLock.hpp"
#include "csf/Task.hpp"
#include "jcfcoreutils/FunctionTask.h"
#include "csfunified/framework/ServicesDispatcher.h"
#include "csfunified/framework/FunctorTask.h"
#include "csfunified/services/impl/BaseToImplCast.h"
#include "boost/bind.hpp"

namespace CSFUnified {
    
    InstantMessageCallback::InstantMessageCallback()
    {
    }
    
    InstantMessageCallback::~InstantMessageCallback()
    {
    }
    
    void InstantMessageCallback::OnInstantMessageCommandReceived(std::string uri, std::string participantUri, InstantMessageCommandCodeEnum::InstantMessageCommandCode commandCode, std::string commandContent, std::string plaintext, std::string richtext, bool isGroupChatCmd)
    {
        if (isGroupChatCmd)
        {
            return;
        }
        
        std::string sessionName = uri;
        std::string cmdMsg = commandContent;
        
        switch(commandCode)
        {
            case InstantMessageCommandCodeEnum::IMCMD_CALENDAR_REMINDER:
            {
                MeetingSDKWrap::getInstance()->getMeetingCalendar()->receiveReminder(sessionName.c_str(), RT_ATTENDEE_MANUAL_REMIND, cmdMsg.c_str());
                break;
            }

            case InstantMessageCommandCodeEnum::IMCMD_CALENDAR_INVITEMORE:
            {
                MeetingSDKWrap::getInstance()->getMeetingCalendar()->receiveReminder(sessionName.c_str(), RT_ATTENDEE_MANUAL_INVITE, cmdMsg.c_str());
                break;
            }

            case InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_INVITATION:
            {
                MeetingSDKWrap::getInstance()->getDSMgr()->receiveDSInvitation(sessionName.c_str(), cmdMsg.c_str());
                break;
            }

            case InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_DECLINE:
            {
                MeetingSDKWrap::getInstance()->getDSMgr()->receiveDSDecline(sessionName.c_str());
                break;
            }

            case InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_CANCELINVITATION:
            {
                MeetingSDKWrap::getInstance()->getDSMgr()->receiveDSCancelled(sessionName.c_str());
                break;
            }

            case InstantMessageCommandCodeEnum::IMCMD_MEETING_INVITE:
            {
                MeetingSDKWrap::getInstance()->getInstantMeetingMgr()->receiveMeetingInvitation(sessionName.c_str(), cmdMsg.c_str());
                break;
            }

            case InstantMessageCommandCodeEnum::IMCMD_MEETING_DECLINE:
            {
                MeetingSDKWrap::getInstance()->getInstantMeetingMgr()->receiveMeetingDeclinedMsg(sessionName.c_str(), cmdMsg.c_str());
                break;
            }

            case InstantMessageCommandCodeEnum::IMCMD_MEETING_CANCELINVITATION:
            {
                MeetingSDKWrap::getInstance()->getInstantMeetingMgr()->receiveMeetingCancelledMsg(sessionName.c_str(), cmdMsg.c_str());
                break;
            }

            case InstantMessageCommandCodeEnum::IMCMD_WBXMEETING_INVITATE_ATTENDEES_:
            {
                MeetingSDKWrap::getInstance()->getMeetingCalendar()->receiveReminder(sessionName.c_str(), RT_HOST_AUTO_REMIND, cmdMsg.c_str());
                break;
            }

            case InstantMessageCommandCodeEnum::IMCMD_CMR_MEETING_INVITATION:
            {
                NULL;
                break;
            }
                
            default:
                break;
        }
    }
    
    //
    InstantMessageMgr* InstantMessageMgr::m_pInstance = NULL;
    
    InstantMessageMgr::InstantMessageMgr()
    {
        m_callback.reset(new InstantMessageCallback());
    }
    
    InstantMessageMgr::~InstantMessageMgr()
    {
        if (NULL != m_imProvider.get() && NULL != m_callback.get())
        {
            m_imProvider->UnregisterInstantMessageCommandReceivedCallback(m_callback);
            m_callback.reset();
        }
    }
    
    InstantMessageMgr* InstantMessageMgr::getInstance()
    {
        if (NULL == m_pInstance)
        {
            m_pInstance = new InstantMessageMgr();
        }
        
        return m_pInstance;
    }
    
    void InstantMessageMgr::releaseInstance()
    {
        if (NULL != m_pInstance)
        {
            delete m_pInstance;
            m_pInstance = NULL;
        }
    }
    
    void InstantMessageMgr::start()
    {
        if (NULL == m_unifiedFactory.get())
        {
            return;
        }
        
        stop(); //If imProvider hasn't been released, release it firstly
        
        m_imProvider = m_unifiedFactory->getService<InstantMessageConversationService>();
        
        if (NULL != m_imProvider.get())
        {
            std::vector<InstantMessageCommandCodeEnum::InstantMessageCommandCode>* pCmds = new std::vector<InstantMessageCommandCodeEnum::InstantMessageCommandCode>();
            pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_CALENDAR_REMINDER);
            pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_CALENDAR_INVITEMORE);
            pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_INVITATION);
            pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_DECLINE);
            pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_CANCELINVITATION);
            pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_MEETING_INVITE);
            pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_MEETING_DECLINE);
            pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_MEETING_CANCELINVITATION);
            pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_WBXMEETING_INVITATE_ATTENDEES_);
            pCmds->push_back(InstantMessageCommandCodeEnum::IMCMD_CMR_MEETING_INVITATION);

            SMART_PTR_NS::shared_ptr< std::vector<InstantMessageCommandCodeEnum::InstantMessageCommandCode> > cmds;
            cmds.reset(pCmds);
            
            m_imProvider->RegisterInstantMessageCommandReceivedCallback(m_callback, cmds);
        }
    }
    
    void InstantMessageMgr::stop()
    {
        if (NULL != m_imProvider.get())
        {
            if (NULL != m_callback.get())
            {
                m_imProvider->UnregisterInstantMessageCommandReceivedCallback(m_callback);
            }
            
            m_imProvider.reset();
        }
    }
    
    void InstantMessageMgr::setUnifiedFactory(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory)
    {
        m_unifiedFactory = unifiedFactory;
    }
    
    //
    void InstantMessageMgr::sendMeetingInviteCmd(const std::string& buddyName, const std::string& cmdContent, const std::string& richText, const std::string& plainText)
    {
        sendImCommand(buddyName, InstantMessageCommandCodeEnum::IMCMD_MEETING_INVITE, cmdContent, richText, plainText);
    }
    
    void InstantMessageMgr::sendMeetingCancelCmd(const std::string& buddyName, const std::string& cmdContent)
    {
        sendImCommand(buddyName, InstantMessageCommandCodeEnum::IMCMD_MEETING_CANCELINVITATION, cmdContent, "", "");
    }
    
    void InstantMessageMgr::sendMeetingDeclineCmd(const std::string& buddyName, const std::string& cmdContent)
    {
        sendImCommand(buddyName, InstantMessageCommandCodeEnum::IMCMD_MEETING_DECLINE, cmdContent, "", "");
    }
    
    void InstantMessageMgr::sendDesktopShareInviteCmd(const std::string& buddyName, const std::string& cmdContent, const std::string& richText, const std::string& plainText)
    {
        sendImCommand(buddyName, InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_INVITATION, cmdContent, richText, plainText);
    }
    
    void InstantMessageMgr::sendDesktopShareCancelCmd(const std::string& buddyName, const std::string& cmdContent)
    {
        sendImCommand(buddyName, InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_CANCELINVITATION, cmdContent, "", "");
    }
    
    void InstantMessageMgr::sendDesktopShareDeclineCmd(const std::string& buddyName, const std::string& cmdContent)
    {
        sendImCommand(buddyName, InstantMessageCommandCodeEnum::IMCMD_DESKTOPSHARE_DECLINE, cmdContent, "", "");
    }
    
    void InstantMessageMgr::sendMeetingRemindCmd(const std::string& buddyName, const std::string& cmdContent, const std::string& richText, const std::string& plainText)
    {
        sendImCommand(buddyName, InstantMessageCommandCodeEnum::IMCMD_WBXMEETING_INVITATE_ATTENDEES_, cmdContent, richText, plainText);
    }
    
    void InstantMessageMgr::sendCalendarRemindCmd(const std::string& buddyName, const std::string& cmdContent, const std::string& richText, const std::string& plainText)
    {
        sendImCommand(buddyName, InstantMessageCommandCodeEnum::IMCMD_CALENDAR_REMINDER, cmdContent, richText, plainText);
    }
    
    void InstantMessageMgr::sendCalendarInviteCmd(const std::string& buddyName, const std::string& cmdContent, const std::string& richText, const std::string& plainText)
    {
        sendImCommand(buddyName, InstantMessageCommandCodeEnum::IMCMD_CALENDAR_INVITEMORE, cmdContent, richText, plainText);
    }
    
    void InstantMessageMgr::SendCmd_CMRMeetingInvitation(const std::string& url, const std::string& cmdContent, const std::string& richText, const std::string& plainText)
    {
        sendGCCommand(url, InstantMessageCommandCodeEnum::IMCMD_CMR_MEETING_INVITATION, cmdContent, richText, plainText);
    }
    
    //
    InstantMessageConversationService* InstantMessageMgr::getImProvider()
    {
        return m_imProvider.get();
    }
    
    void InstantMessageMgr::sendImCommand(const std::string& buddyName, InstantMessageCommandCodeEnum::InstantMessageCommandCode imcmd, const std::string& cmdContent, const std::string& richText, const std::string& plainText)
    {
        //csf::ScopedReadRWLock lock(mLock);
        bool isOnDispatcher = m_unifiedFactory->getServicesDispatcher()->checkForUpdateAccess();
        
        if(isOnDispatcher)
        {
            sendImCommandinMainThread(buddyName, imcmd, cmdContent, richText, plainText);
        }
        else
        {
            //        csf::TaskPtr task(new JCFCoreUtils::FunctionTask(std::bind(&InstantMessageMgr::sendImCommandinMainThread, this, buddyName, imcmd, cmdContent, richText, plainText),
            //                                                              "MeetingAccountMgrAdapter::sendImCommandinMainThread")
            //                          );
            //        m_unifiedFactory->getServicesDispatcher()->enqueueBlock(task);
            
            m_unifiedFactory->getServicesDispatcher()->enqueueBlock(boost::bind(&InstantMessageMgr::sendImCommandinMainThread, this, buddyName, imcmd, cmdContent, richText, plainText),
                                                                    "MeetingAccountMgrAdapter::sendImCommandinMainThread");
        }
    }
    
    void InstantMessageMgr::sendImCommandinMainThread(const std::string& buddyName, InstantMessageCommandCodeEnum::InstantMessageCommandCode imcmd, const std::string& cmdContent, const std::string& richText, const std::string& plainText)
    {
        if (NULL == getImProvider())
        {
            return;
        }
        
        getImProvider()->SendInstantMessageCommand(buddyName, imcmd, cmdContent, richText, plainText);
    }
    
    void InstantMessageMgr::sendGCCommand(const std::string& url, InstantMessageCommandCodeEnum::InstantMessageCommandCode imcmd, const std::string& cmdContent, const std::string& richText, const std::string& plainText)
    {
        //csf::ScopedReadRWLock lock(mLock);
        bool isOnDispatcher = m_unifiedFactory->getServicesDispatcher()->checkForUpdateAccess();
        
        if(isOnDispatcher)
        {
            sendGCCommandinMainThread(url, imcmd, cmdContent, richText, plainText);
        }
        else
        {
            m_unifiedFactory->getServicesDispatcher()->enqueueBlock(boost::bind(&InstantMessageMgr::sendGCCommandinMainThread, this, url, imcmd, cmdContent, richText, plainText),
                                                                    "MeetingAccountMgrAdapter::sendImCommandinMainThread");
        }
    }
    
    void InstantMessageMgr::sendGCCommandinMainThread(const std::string& url, InstantMessageCommandCodeEnum::InstantMessageCommandCode imcmd, const std::string& cmdContent, const std::string& richText, const std::string& plainText)
    {
        if (NULL == getImProvider())
        {
            return;
        }
        
        getImProvider()->SendGroupChatInstantMessageCommand(url, imcmd, cmdContent, richText, plainText);
    }
}